/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.container;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.quark.addons.oddities.module.CrateModule;
import vazkii.quark.addons.oddities.tile.CrateTileEntity;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.ScrollCrateMessage;

public class CrateContainer
extends Container {
    public final CrateTileEntity crate;
    public final PlayerInventory playerInv;
    public static final int numRows = 6;
    public static final int numCols = 9;
    public static final int displayedSlots = 54;
    public int scroll = 0;
    private final IIntArray crateData;

    public CrateContainer(int id, PlayerInventory inv, CrateTileEntity crate) {
        this(id, inv, crate, (IIntArray)new IntArray(2));
    }

    public CrateContainer(int id, PlayerInventory inv, CrateTileEntity crate, IIntArray data) {
        super(CrateModule.containerType, id);
        crate.func_174889_b(inv.field_70458_d);
        this.crate = crate;
        this.playerInv = inv;
        this.crateData = data;
        int i = 36;
        for (int j = 0; j < 6; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new CrateSlot(k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)inv, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)inv, i1, 8 + i1 * 18, 161 + i));
        }
        this.func_216961_a(this.crateData);
    }

    public int getTotal() {
        return this.crateData.func_221476_a(0);
    }

    public int getStackCount() {
        return this.crateData.func_221476_a(1);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            boolean empty = false;
            if (index < 54) {
                if (!this.func_75135_a(itemstack1, 54, this.field_75151_b.size(), true)) {
                    empty = true;
                }
                this.crate.func_70296_d();
            } else if (MiscUtil.canPutIntoInv(itemstack, (TileEntity)this.crate, Direction.UP, true)) {
                MiscUtil.putIntoInv(itemstack, (TileEntity)this.crate, Direction.UP, false, false);
                itemstack1.func_190920_e(0);
                empty = true;
            } else {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                if (slot instanceof CrateSlot) {
                    CrateSlot cslot = (CrateSlot)slot;
                    int target = cslot.getTarget();
                    this.crate.func_70304_b(target);
                } else {
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
            } else if (!empty) {
                slot.func_75218_e();
                this.forceSync();
            }
            if (empty) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    public static CrateContainer fromNetwork(int windowId, PlayerInventory playerInventory, PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        CrateTileEntity te = (CrateTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(pos);
        return new CrateContainer(windowId, playerInventory, te);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.crate.func_70300_a(playerIn);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.crate.func_174886_c(playerIn);
    }

    private void forceSync() {
        World world = this.crate.func_145831_w();
        if (!world.field_72995_K) {
            for (IContainerListener icontainerlistener : this.field_75149_d) {
                icontainerlistener.func_71110_a((Container)this, this.func_75138_a());
            }
        }
    }

    public void scroll(boolean down, boolean packet) {
        boolean did = false;
        if (down) {
            int target = this.scroll + 9;
            int maxScroll = this.getStackCount() / 9 * 9;
            if (target <= maxScroll) {
                this.scroll = target;
                did = true;
            }
        } else {
            int target = this.scroll - 9;
            if (target >= 0) {
                this.scroll = target;
                did = true;
            }
        }
        if (did) {
            this.func_75142_b();
            if (packet) {
                QuarkNetwork.sendToServer(new ScrollCrateMessage(down));
            }
        }
    }

    private class CrateSlot
    extends Slot {
        private final int index;

        public CrateSlot(int index, int xPosition, int yPosition) {
            super((IInventory)CrateContainer.this.crate, index, xPosition, yPosition);
            this.index = index;
        }

        private int getTarget() {
            World world = CrateContainer.this.crate.func_145831_w();
            return world.field_72995_K ? this.index : this.index + CrateContainer.this.scroll;
        }

        public ItemStack func_75211_c() {
            int size;
            int targetIndex = this.getTarget();
            if (targetIndex >= (size = CrateContainer.this.crate.func_70302_i_())) {
                return ItemStack.field_190927_a;
            }
            return CrateContainer.this.crate.func_70301_a(targetIndex);
        }

        public void func_75215_d(ItemStack stack) {
            int targetIndex = this.getTarget();
            this.field_75224_c.func_70299_a(targetIndex, stack);
            this.func_75218_e();
            CrateContainer.this.forceSync();
        }

        public ItemStack func_75209_a(int amount) {
            return this.field_75224_c.func_70298_a(this.getTarget(), amount);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_190916_E() + CrateContainer.this.getTotal() <= CrateModule.maxItems;
        }
    }
}

